/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGitHandler
extends AbstractHandler {
    private IEvaluationContext evalContext;
    private boolean enabled;
    private Collection<IResource> selectedResources;

    public void setSelectedResources(Collection<IResource> resources) {
        this.selectedResources = resources;
    }

    protected void openError(String title, String msg) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)AbstractGitHandler.this.getShell(), (String)Messages.CommitAction_MultipleRepos_Title, (String)Messages.CommitAction_MultipleRepos_Message);
            }
        });
    }

    protected Shell getShell() {
        return UIUtils.getActiveShell();
    }

    public void setEnabled(Object evaluationContext) {
        this.evalContext = (IEvaluationContext)evaluationContext;
        try {
            this.enabled = this.calculateEnabled();
        }
        finally {
            this.evalContext = null;
        }
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected IWorkbenchPage getActivePage() {
        return UIUtils.getActivePage();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.evalContext = (IEvaluationContext)event.getApplicationContext();
        try {
            Object object = this.doExecute(event);
            return object;
        }
        finally {
            this.evalContext = null;
        }
    }

    protected abstract Object doExecute(ExecutionEvent var1) throws ExecutionException;

    protected Set<GitRepository> getSelectedRepositories() {
        Collection<IResource> resources = this.getSelectedResources();
        if (resources == null || resources.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<GitRepository> repos = new HashSet<GitRepository>();
        for (IResource resource : resources) {
            if (resource == null) continue;
            IProject project = resource.getProject();
            GitRepository repo = AbstractGitHandler.getGitRepositoryManager().getAttached(project);
            if (repo == null) continue;
            repos.add(repo);
        }
        return repos;
    }

    protected IEditorPart getEditor() {
        IWorkbenchPart activePart = (IWorkbenchPart)this.evalContext.getVariable("activePart");
        if (activePart instanceof IEditorPart) {
            return (IEditorPart)activePart;
        }
        return null;
    }

    protected Collection<IResource> getSelectedResources() {
        if (this.selectedResources != null) {
            return this.selectedResources;
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Object activePart = this.evalContext.getVariable("activePart");
        if (activePart instanceof IEditorPart) {
            IEditorInput input = (IEditorInput)this.evalContext.getVariable("activeEditorInput");
            resources.add((IResource)input.getAdapter(IResource.class));
        } else {
            Object selection = this.evalContext.getVariable("selection");
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection struct = (IStructuredSelection)selection;
                for (Object firstElement : struct.toList()) {
                    if (firstElement instanceof IResource) {
                        resources.add((IResource)firstElement);
                        continue;
                    }
                    if (!(firstElement instanceof IAdaptable)) continue;
                    IAdaptable adaptable = (IAdaptable)firstElement;
                    resources.add((IResource)adaptable.getAdapter(IResource.class));
                }
            }
        }
        return resources;
    }

    protected static IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    protected GitRepository getSelectedRepository() {
        Set<GitRepository> repos = this.getSelectedRepositories();
        if (repos == null || repos.isEmpty()) {
            return null;
        }
        return repos.iterator().next();
    }
}

